(*| 21:49 13/10/1993 *)
UNIT EGAEdit;

INTERFACE

PROCEDURE EditChar;

PROCEDURE ExpandFont;

PROCEDURE ShrinkFont;

PROCEDURE DoubleHeight;

IMPLEMENTATION

USES Crt,StdTypes,EGAScreen,EGAVars,EGAWait,EGAUtils,EGADos;

VAR
  EditKey: Char;
  EditKeyFunc: KeyType;
  EditExit: Boolean;

PROCEDURE ShowScrChar(EditByte,Pos: BYTE);
VAR
  I:Integer;
BEGIN
  IF Pos = 0 THEN BEGIN
    ClrScr;
    Heading;
    GotoXY(50,1);
    ShowByteVal(EditByte);
  END;
  FOR I:=0 TO BytesPerChar-1 DO IF I < 24 THEN BEGIN
    GotoXY(Pos+1,I+2);
    ShowByte(IndexPtr(FontCharPtrs[EditByte],I)^);
  END;
END;  { ShowScrChar }

PROCEDURE TogglePixel(EditByte: BYTE; X,Y: Integer);
VAR
  ThisPtr:BytePointer;
BEGIN
  ThisPtr:=IndexPtr(FontCharPtrs[EditByte],Y);
  ThisPtr^:=ThisPtr^ XOR Mask[X];
  GotoXY(1,2+Y);
  ShowByte(ThisPtr^);
  FontUpdated:=True;
END;  { TogglePixel }

PROCEDURE EraseChar(EditByte: BYTE);
VAR
  ThisPtr:BytePointer;
  I:Integer;
BEGIN
  ThisPtr:=FontCharPtrs[EditByte];
  FOR I:=0 TO BytesPerChar-1 DO
    IndexPtr(ThisPtr,I)^:=0;
  FontUpdated:=True;
  ShowScrChar(EditByte,0);
END;  { EraseChar }

PROCEDURE CopyChar(OldByte,NewByte: BYTE);
VAR
  OldPtr,NewPtr:BytePointer;
  I:Integer;
BEGIN
  OldPtr:=FontCharPtrs[OldByte];
  NewPtr:=FontCharPtrs[NewByte];
  FOR I:=0 TO BytesPerChar-1 DO
    IndexPtr(NewPtr,I)^:=IndexPtr(OldPtr,I)^;
  FontUpdated:=True;
END;  { CopyChar }

PROCEDURE CopyOtherChar(OldByte,NewByte: BYTE);
VAR
  OldPtr,NewPtr:BytePointer;
  I:Integer;
BEGIN
  IF FontNumber = 1 THEN
    OldPtr:=Font2CharPtrs[OldByte]
  ELSE
    OldPtr:=Font1CharPtrs[OldByte];
  NewPtr:=FontCharPtrs[NewByte];
  FOR I:=0 TO BytesPerChar-1 DO
    IndexPtr(NewPtr,I)^:=IndexPtr(OldPtr,I)^;
  FontUpdated:=True;
END;  { CopyOtherChar }

PROCEDURE ShowHelp(EditByte: BYTE);
BEGIN
  ClrScr;
  Writeln('ESC to return to main menu.');
  Writeln('SPACE to toggle pixel setting.');
  Writeln('Cursor keys to move around the pixels.');
  Writeln('PgUp,PgDn to move half screen up/down for large characters.');
  Writeln('F3 Copy another character');
  IF FontNumber <> 0 THEN
    Writeln('F4 Copy character from other font');
  Writeln('F5 Show subsequent cells.');
  Writeln('F6 Show this cell only. Use after F5.');
  Writeln('F7 Show lo bit and hi bit chars adjacent.');
  Writeln('F8 Demonstrate user font');
  Writeln('F9 Demonstrate user font lo hi');
  Writeln('F10 Erase this cell.');
  Writeln;
  Continue;
  ShowScrChar(EditByte,0);
END;  { ShowHelp }

PROCEDURE EditScrPixels(EditByte: BYTE);
VAR
 I,X,Y: Integer;
 K: Char;
 KF,CKF: KeyType;
 CopyByte: BYTE;
BEGIN
  X:=0;
  Y:=0;
  REPEAT
    GotoXY(60,1);
    ClrEOL;
    GotoXY(X+1,Y+2);
    WaitKey(K,KF);
    CASE KF OF
      Normal: BEGIN
                IF K=' ' THEN TogglePixel(EditByte,X,Y);
                IF K='?' THEN ShowHelp(EditByte);
              END;
      Cleft : IF X > 0 THEN DEC(X);
      Cright: IF X < 7 THEN INC(X);
      Cup   : IF Y > 0 THEN DEC(Y);
      Cdown : IF Y < BytesPerChar-1 THEN INC(Y);
      Chome : BEGIN
                X:=0;
                Y:=0;
              END;
      Cend  : BEGIN
                X:=7;
                Y:=BytesPerChar-1;
              END;
      F1    : ShowHelp(EditByte);
      F3    : BEGIN
(*
               Write('Char to be copied : ');
               Readln(CopyByte);
               CopyByte:=CHR(ORD(CopyByte)+(ORD(EditByte) AND $80));
               CopyChar(ORD(CopyByte),EditByte);
*)
               SetEditByte(CopyByte,CKF);
               IF CKF = RET THEN
                 CopyChar(CopyByte,EditByte);
               ShowScrChar(EditByte,0);
              END;
      F4    : IF FontNumber <> 0 THEN BEGIN
                SetEditByte(CopyByte,CKF);
                IF CKF = RET THEN BEGIN
                  CopyOtherChar(CopyByte,EditByte);
                END;
                ShowScrChar(EditByte,0);
              END;
      F5    : FOR I:= 1 TO 9 DO
                ShowScrChar(EditByte+I,I*8);
      F6    : ShowScrChar(EditByte,0);
      F7    : BEGIN
                ShowScrChar(EditByte AND $7F,32);
                ShowScrChar(EditByte OR $80,40);
              END;
      F8    : BEGIN
                ShowFont(False,EditByte);
                ShowScrChar(EditByte,0);
              END;
      F9    : BEGIN
                ShowFont(True,$20);
                ShowScrChar(EditByte,0);
              END;
      F10   : EraseChar(EditByte);
    END;
  UNTIL KF=ESC;
END;  { EditScrPixels }

PROCEDURE EditChar;
VAR
  EditByte: Byte;
BEGIN
  EditExit:=False;
  REPEAT
    SetEditByte(EditByte,EditKeyFunc);
    IF EditKeyFunc=ESC THEN
      EditExit:=True;
    IF EditKeyFunc=RET THEN BEGIN
      ShowScrChar(EditByte,0);
      EditScrPixels(EditByte);
      ClrScr;
    END;
  UNTIL EditExit=True;
END;  { EditChar }

PROCEDURE FontDownCopy(OldPtr,NewPtr: BytePointer; Count,Blank: Integer);
VAR
  I:Integer;
BEGIN
  FOR I:=Count-1 DOWNTO 0 DO
    IndexPtr(NewPtr,I)^:=IndexPtr(OldPtr,I)^;
  IF Blank > 0 THEN
    FOR I:=0 TO Blank-1 DO
      IndexPtr(NewPtr,Count+I)^:=0;
END;  { FontDownCopy }

PROCEDURE ExpandTo(NewSize: Integer);
VAR
  I,Diff: Integer;
  OldPtr: BytePointer;
BEGIN
  Diff:=NewSize-BytesPerChar;
  FOR I:=MaxCharNum DOWNTO 0 DO BEGIN
    OldPtr:=FontCharPtrs[I];
    FontCharPtrs[I]:=IndexPtr(FontCharPtrs[0],NewSize*I);
    FontDownCopy(OldPtr,FontCharPtrs[I],BytesPerChar,Diff);
  END;
  BytesPerChar:=NewSize;
  FontFileSize:=BytesPerChar*256;
  FontUpdated:=True;
END;  { ExpandTo }

PROCEDURE ExpandFont;
VAR
  NewSize: Integer;
BEGIN
  Write(BytesPerChar,' New Larger Size : ');
  NewSize:=GetNum(2,BytesPerChar,32,BytesPerChar);
  IF NewSize > BytesPerChar THEN
    ExpandTo(NewSize);
END;  { ExpandFont }

PROCEDURE FontUpCopy(OldPtr,NewPtr: BytePointer; Count: Integer);
VAR
  I:Integer;
BEGIN
  FOR I:=0 TO Count-1 DO
    IndexPtr(NewPtr,I)^:=IndexPtr(OldPtr,I)^;
END;  { FontUpCopy }

PROCEDURE ShrinkTo(NewSize,Offset: Integer);
VAR
  I: Integer;
  OldPtr: BytePointer;
BEGIN
  FOR I:=0 TO MaxCharNum DO BEGIN
    OldPtr:=FontCharPtrs[I];
    FontCharPtrs[I]:=IndexPtr(FontCharPtrs[0],NewSize*I);
    FontUpCopy(IndexPtr(OldPtr,Offset),FontCharPtrs[I],NewSize);
  END;
  BytesPerChar:=NewSize;
  FontFileSize:=BytesPerChar*256;
  FontUpdated:=True;
END;  { ShrinkTo }

PROCEDURE ShrinkFont;
VAR
  NewSize,Offset,Limit: Integer;
BEGIN
  Write(BytesPerChar,' New Smaller Size : ');
  NewSize:=GetNum(2,1,BytesPerChar,BytesPerChar);
  Limit:=BytesPerChar - NewSize;
  Write('Offset, 0 to ',Limit,' : ');
  Offset:=GetNum(2,0,Limit,0);
  IF NewSize < BytesPerChar THEN
    ShrinkTo(NewSize,Offset);
END;  { ShrinkFont }

PROCEDURE DoubleBytes(FontPtr: BytePointer);
VAR
  I: Integer;
BEGIN
  FOR I:=(BytesPerChar DIV 2) - 1 DOWNTO 0 DO BEGIN
    IndexPtr(FontPtr,2*I)^:=IndexPtr(FontPtr,I)^;
    IndexPtr(FontPtr,2*I+1)^:=IndexPtr(FontPtr,I)^;
  END;
END;  { DoubleBytes }

PROCEDURE DoubleHeight;
VAR
  I: Integer;
BEGIN
  Writeln('Doubling Height');
  ExpandTo(BytesPerChar*2);
  FOR I:= 0 TO MaxCharNum DO
    DoubleBytes(FontCharPtrs[I]);
END;  { DoubleHeight }

END.
